package Config;

#--------------------------
# Program: windProbs_config.pl
#
# Purpose: Wind Speed Probability Graphics configuration file
#
# Written: A. Krautkramer 6/2006
# Modified: M. Klein/HPC 7/2008  Configure for HPC usage.
# 08/11/2010  A. Robson   Corrected entry for ncosrv ip address.
# 09/30/2011  A. Robson   Changed HPC backup webserver
# 10/06/2011  M. Klein    Change storm marker diamond file.
# 06/13/2012  A. Robson   Added $NHCBKUPWEB, which is set in .cshrc

#=====================================
#       ***  Environment variables
#=====================================

$NHCBKUPWEB=$ENV{'NHCBKUPWEB'};  # The server address is now set in the .chsrc
# NCWCP: vm-lnx-nhcbkup.ncep.noaa.gov
# WWB vp-tpcbkup.ncep.noaa.gov


#=====================================
#       ***  Directories
#=====================================

$homeDir = $ENV{HOME};
$probDir = "$homeDir/wgraph/wndprb";		# top level directory for probabilities
$workDir = "$probDir/working";	        # working directory (end plotParams file saved here)
$binDir =  "$probDir/scripts";	        # perl program and scripts directory
$opsdir = "/export-5/ncosrvnfs/hpcops";  # HPC scripts directory.
$archivedir = "/export-4/ncosrvnfs/hpcops/grids/atcf"; # Top-level directory for archived TPC products.


$dataDir = "$probDir/data";      	# top-level directory for grid/corners files
#$gribDir = "$dataDir/incoming/grib";
$gribDir = "$archivedir/wndprbfiles";   # directory for archiving grib files
$gridDir = "$dataDir/incoming/grid"; 	# directory containing grid/corners files
$imageDir = "$binDir/images";		# directory containing additional images
$outputDir = "$dataDir/outgoing";		# wind prob images storage directory
$outputLogDir = "$outputDir/logs";		# process log storage directory


$atcfDir = "$homeDir/wgraph"; 	        # directory containing ATCF advisories/adecks
$marDir  = "$atcfDir/mar";	#  marine advisory directory
$pubDir  = "$atcfDir/pub";	#  public advisory directory
$disDir  = "$atcfDir/dis"; 	#  discussion directory
$aidDir  = "$atcfDir/aid"; 	#  a-deck directory  
$advDir  = "$atcfDir/adv"; 	#  advisory text info directory



#=====================================
#       ***  Programs
#=====================================

$convert = "/usr/bin/convert";
$NAWIPS_EXE = $ENV{NAWIPS_EXE};


			
#=====================================
#       ***  Files
#=====================================
	
$plotParams = "$workDir/plotParams";		# plotParams file (this programs output)

#$noaaLogo = "NOAA_50x50_lowcolor.gif";
#$nwsLogo = "NWS_50x50_lowcolor.gif";

#--- ARK - Changed to new logos on 6/19/2007
$noaaLogo = "noaa_logo_edit.gif";
$nwsLogo = "nws_logo_edit.gif";
 
$clrBar = "colorbar2.gif";
$stormMarker = "stormMarker_4.gif";
$noImage = "notready_lg.gif";		#--- ARK added for 0 - 108 prelim wind probs
	


#=====================================
#       *** Web Server
#=====================================

#$remoteMachine1 = "140.90.48.96";	#--- seahorse.nhc.noaa.gov (ip = 140.90.48.96)
#$remoteMachine1 =  "vp-tpcbkup.ncep.noaa.gov";# ---WWB HPC backup server. 
$remoteMachine1 = "$NHCBKUPWEB"; # This is set in .cshrc and depends where script is run from.
# NCWCP: vm-lnx-nhcbkup.ncep.noaa.gov, 
# WWB vp-tpcbkup.ncep.noaa.gov
#$remoteMachine2 = "140.90.48.52";	#--- ratfish.nhc.noaa.gov (ip = 140.90.48.52)
#$remoteMachine3 = "140.90.176.27";	#--- largo.nhc.noaa.gov (ip = 140.90.176.27)
$remoteUser = "graphics";

#=====================================
#       *** Process Control FLags
#=====================================

$sendToWeb = 1;		# 1 -> yes, 0 -> no
$gempakLogo = 0;	# 1 - gempak 0 - convert to add logos
$gempakText = 0;	# 1 - gempak 0 - convert to add text boxes	
$gempakClrBar = 0;	# 1- gempak 0 - convert to add color bar


#=====================================
#       ***  Perl Packages
#=====================================

$generalUtils = "$binDir/generalUtils_v1.2.4.pl";
$windPlot = "$binDir/windProbs_plot.pl";
$getStormInfo = "$binDir/getStormInfo.pl";	# parses ATCF files for storm info
$gemClean = "$binDir/gem_clean.pl";		# remove left over message queues


1;

